﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data;
using BMS.VistaIntegration.Mdws2.Maps.WF;
using BMS.VistaIntegration.Mdws2.Abstract;
using BMS.VistaIntegration.Mdws2.QuerySvcService;

namespace BMS.VistaIntegration.Mdws2.Implementation.WF
{
    class OrderActionCommand : BaseCommand<OrderAction>
    {
        public OrderActionCommand()
            : base(OrderActionMap.Instance)
        {
        }

        public string PatientIen { get; set; }

        public IEnumerable<string> OrderableItemsIen { get; set; }

        protected override Predicate<OrderAction> GetPredicate()
        {
            return Utilities.MakePredicate<OrderAction>(StartDate, EndDate, (e) => e.DateTimeOrdered);
        }

        protected override string GetScreenParam()
        {
            string result = string.Format("{0}{1}{2}{3}", StatusScreen ,  GetPatientScreen(), GetScreenOrderableItems(), GetScreenFilterDateTime());
            return result;
        }

        private string GetScreenFilterDateTime()
        {
            if (StartDate.HasValue && EndDate.HasValue)
                return string.Format(StartEndDateScreen, StartDate.Value.VistAToInternalFormat(), EndDate.Value.VistAToInternalFormat());

            if (StartDate.HasValue)
                return string.Format(StartDateScreen, StartDate.Value.VistAToInternalFormat());

            if (EndDate.HasValue)
                return string.Format(EndDateScreen, EndDate.Value.VistAToInternalFormat());

            return string.Empty;
        }

        private string GetPatientScreen()
        {
            return string.IsNullOrEmpty(PatientIen) ?
                string.Empty :
                string.Format(PatientScreen, PatientIen);
        }

        
        private string GetScreenOrderableItems()
        {
            if (OrderableItemsIen == null)
                return string.Empty;

            StringBuilder sb = new StringBuilder();
            foreach (string s in OrderableItemsIen)
            {
                sb.Append("(v=");
                sb.Append(s);
                sb.Append(")!");
            }
            sb.Remove(sb.Length - 1, 1);
            if (!StartDate.HasValue && !EndDate.HasValue) sb.Append('Q');
            return string.Format(OrderableItemsFilter, sb);
        }

        public override IList<OrderAction> Execute(QuerySvcSoap client)
        {
            if (OrderableItemsIen != null && !OrderableItemsIen.Any())
            {
                return Enumerable.Empty<OrderAction>().ToList();
            }
            return base.Execute(client);
        }

        private const string StatusScreen = "S x=$P(^(3),U,3)  I (x=6)!(x=13) ";
        private const string StartDateScreen = "S x=0 S $T=0 F  S x=$O(^OR(100,Y,\"8\",x)) Q:'+x  S v=$P(^OR(100,Y,\"8\",x,0),U,1) I v>={0} Q";
        private const string EndDateScreen = "S x=0 S $T=0 F  S x=$O(^OR(100,Y,\"8\",x)) Q:'+x  S v=$P(^OR(100,Y,\"8\",x,0),U,1) I v<{0} Q";
        private const string StartEndDateScreen = "S x=0 S $T=0 F  S x=$O(^OR(100,Y,\"8\",x)) Q:'+x  S v=$P(^OR(100,Y,\"8\",x,0),U,1) I (v>={0})&(v<{1}) Q";
        private const string PatientScreen = "I $P(^OR(100,Y,0),U,2)=\"{0};DPT(\" ";
        private const string OrderableItemsFilter = "S x=0 S $T=0 F  S x=$O(^OR(100,Y,\".1\",x)) Q:'+x  S v=$P(^OR(100,Y,\".1\",x,0),U,1) I {0} ";
    }
}
